/*
 * Decompiled with CFR 0.152.
 */
package one;

import one.Match;

public class Sequence {
    final int MAX_LENGTH = 100;
    int length;
    String descriptor;
    char[] sequence;

    public Sequence() {
        this.sequence = new char[100];
        this.descriptor = "no name yet";
        this.length = 0;
    }

    public Sequence(String dnaString) {
        this.descriptor = "String one";
        this.sequence = new char[100];
        this.length = dnaString.length();
        for (int i = 0; i < this.length; ++i) {
            this.sequence[i] = dnaString.charAt(i);
        }
    }

    public String getDescr() {
        return this.descriptor;
    }

    public String getSeq() {
        String retSeq = "";
        for (int i = 0; i < this.length; ++i) {
            retSeq = retSeq + this.sequence[i];
        }
        return retSeq;
    }

    public int getLength() {
        return this.length;
    }

    public char getBase(int place) {
        return this.sequence[place];
    }

    public Match simpleMatch(Sequence seq, int matchValue, int misValue, int gapValue, int initGapValue, int finalGapValue) {
        int[][] vMatrix = new int[seq.getLength() + 1][this.length + 1];
        char[][] pMatrix = new char[seq.getLength() + 1][this.length + 1];
        vMatrix[0][0] = 0;
        pMatrix[0][0] = 110;
        for (int i = 1; i <= seq.getLength(); ++i) {
            vMatrix[i][0] = vMatrix[i - 1][0] + initGapValue;
            pMatrix[i][0] = 118;
        }
        for (int j = 1; j <= this.length; ++j) {
            vMatrix[0][j] = vMatrix[0][j - 1] + initGapValue;
            pMatrix[0][j] = 104;
        }
        for (int i = 1; i <= seq.getLength(); ++i) {
            for (int j = 1; j <= this.length; ++j) {
                int fromAbove = j != this.length ? vMatrix[i - 1][j] + gapValue : vMatrix[i - 1][j] + finalGapValue;
                int fromLeft = i != seq.getLength() ? vMatrix[i][j - 1] + gapValue : vMatrix[i][j - 1] + finalGapValue;
                int fromDiag = this.sequence[j - 1] == seq.sequence[i - 1] ? vMatrix[i - 1][j - 1] + matchValue : vMatrix[i - 1][j - 1] + misValue;
                if (fromAbove >= fromLeft && fromAbove >= fromDiag) {
                    vMatrix[i][j] = fromAbove;
                    if (fromAbove == fromLeft && fromAbove == fromDiag) {
                        pMatrix[i][j] = 99;
                        continue;
                    }
                    if (fromAbove == fromLeft) {
                        pMatrix[i][j] = 98;
                        continue;
                    }
                    if (fromAbove == fromDiag) {
                        pMatrix[i][j] = 101;
                        continue;
                    }
                    pMatrix[i][j] = 118;
                    continue;
                }
                if (fromDiag >= fromLeft) {
                    vMatrix[i][j] = fromDiag;
                    if (fromDiag == fromLeft) {
                        pMatrix[i][j] = 102;
                        continue;
                    }
                    pMatrix[i][j] = 100;
                    continue;
                }
                vMatrix[i][j] = fromLeft;
                pMatrix[i][j] = 104;
            }
        }
        int j = this.length;
        int i = seq.getLength();
        String tempTop = "";
        String tempLeft = "";
        int matchLength = 0;
        String top = "";
        String left = "";
        float waysCount = this.countPaths(pMatrix, i, j);
        while (pMatrix[i][j] != 'n') {
            switch (pMatrix[i][j]) {
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    tempLeft = tempLeft + seq.sequence[i - 1];
                    tempTop = tempTop + this.sequence[j - 1];
                    --i;
                    --j;
                    ++matchLength;
                    break;
                }
                case 'b': 
                case 'v': {
                    tempTop = tempTop + '_';
                    tempLeft = tempLeft + seq.sequence[i - 1];
                    --i;
                    ++matchLength;
                    break;
                }
                case 'h': {
                    tempTop = tempTop + this.sequence[j - 1];
                    tempLeft = tempLeft + '_';
                    --j;
                    ++matchLength;
                }
            }
        }
        for (int k = matchLength - 1; k >= 0; --k) {
            top = top + tempTop.charAt(k);
            left = left + tempLeft.charAt(k);
        }
        Match thisMatch = new Match(vMatrix[seq.getLength()][this.length], top, left, vMatrix, pMatrix, (int)waysCount);
        return thisMatch;
    }

    public Match localMatch(Sequence seq, int matchValue, int misValue, int gapValue) {
        int[][] vMatrix = new int[seq.getLength() + 1][this.length + 1];
        char[][] pMatrix = new char[seq.getLength() + 1][this.length + 1];
        vMatrix[0][0] = 0;
        pMatrix[0][0] = 110;
        for (int i = 1; i <= seq.getLength(); ++i) {
            vMatrix[i][0] = 0;
            pMatrix[i][0] = 110;
        }
        for (int j = 1; j <= this.length; ++j) {
            vMatrix[0][j] = 0;
            pMatrix[0][j] = 110;
        }
        for (int i = 1; i <= seq.getLength(); ++i) {
            for (int j = 1; j <= this.length; ++j) {
                int fromAbove = vMatrix[i - 1][j] + gapValue;
                int fromLeft = vMatrix[i][j - 1] + gapValue;
                int fromDiag = this.sequence[j - 1] == seq.sequence[i - 1] ? vMatrix[i - 1][j - 1] + matchValue : vMatrix[i - 1][j - 1] + misValue;
                if (fromAbove >= fromLeft && fromAbove >= fromDiag) {
                    int n = vMatrix[i][j] = fromAbove > 0 ? fromAbove : 0;
                    if (fromAbove == fromLeft && fromAbove == fromDiag) {
                        pMatrix[i][j] = fromAbove > 0 ? 99 : 110;
                        continue;
                    }
                    if (fromAbove == fromLeft) {
                        pMatrix[i][j] = fromAbove > 0 ? 98 : 110;
                        continue;
                    }
                    if (fromAbove == fromDiag) {
                        pMatrix[i][j] = fromAbove > 0 ? 101 : 110;
                        continue;
                    }
                    pMatrix[i][j] = fromAbove > 0 ? 118 : 110;
                    continue;
                }
                if (fromDiag >= fromLeft) {
                    int n = vMatrix[i][j] = fromDiag > 0 ? fromDiag : 0;
                    if (fromDiag == fromLeft) {
                        pMatrix[i][j] = fromDiag > 0 ? 102 : 110;
                        continue;
                    }
                    pMatrix[i][j] = fromDiag > 0 ? 100 : 110;
                    continue;
                }
                vMatrix[i][j] = fromLeft > 0 ? fromLeft : 0;
                pMatrix[i][j] = fromLeft > 0 ? 104 : 110;
            }
        }
        Match thisMatch = new Match(vMatrix[seq.getLength()][this.length], this.sequence.toString(), seq.sequence.toString(), vMatrix, pMatrix, 0);
        return thisMatch;
    }

    public void putDescr(String descr) {
        this.descriptor = descr;
    }

    public void putLength(int len) {
        this.length = len;
    }

    public void putBase(char base, int place) {
        this.sequence[place] = base;
    }

    public int countPaths(char[][] matrix, int i, int j) {
        int paths;
        switch (matrix[i][j]) {
            case 'c': {
                paths = this.countPaths(matrix, i - 1, j) + this.countPaths(matrix, i, j - 1) + this.countPaths(matrix, i - 1, j - 1);
                break;
            }
            case 'b': {
                paths = this.countPaths(matrix, i - 1, j) + this.countPaths(matrix, i, j - 1);
                break;
            }
            case 'e': {
                paths = this.countPaths(matrix, i - 1, j) + this.countPaths(matrix, i - 1, j - 1);
                break;
            }
            case 'f': {
                paths = this.countPaths(matrix, i, j - 1) + this.countPaths(matrix, i - 1, j - 1);
                break;
            }
            case 'h': {
                paths = this.countPaths(matrix, i, j - 1);
                break;
            }
            case 'v': {
                paths = this.countPaths(matrix, i - 1, j);
                break;
            }
            case 'd': {
                paths = this.countPaths(matrix, i - 1, j - 1);
                break;
            }
            case 'n': {
                paths = 1;
                break;
            }
            default: {
                paths = 0;
            }
        }
        return paths;
    }
}

