/*
Creates random symmetric distance matrix in asymmetric format
*/

#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "genrand.h"
#define MAXCOORD 1000000

int main(int argc, char *argv[])
{
	int maxcoord = MAXCOORD;
	int *a;
	int N;
	int i,j;
	int seed;
	int arg = 1;
	int tsplib = 0;

/*	printf("starting\n");*/

	if (argc < 3) {
		printf("Usage: smatgen [-tsplib] #cities seed [maxcoord] > filename\n");
		exit(1);
		}
	if (strcmp(argv[arg], "-tsplib") == 0)  {
		tsplib = 1;
		++arg;
	}
	N = atoi(argv[arg++]);
	a = (int *) malloc(sizeof(int)*(N*(N+1)+1));
        
	seed = atoi(argv[arg++]);
	if (argc > arg) maxcoord = atoi(argv[arg++]);

	/* initialize random number generator */

	sprand(seed);

	for (i=1;i<=N;i++) {
	    for (j=1;j<=N;j++) {
		if (j<i) a[i*N+j] = a[j*N+i];
		else {
			a[i*N+j] = rangerand(maxcoord);
		}
	    }
	    a[i*(N+1)] = 0;
	}

	if (tsplib) {
		printf("NAME: smatgen_%d_%d_%d\n", N, seed, maxcoord);
		printf("TYPE: ATSP\n");
		printf("COMMENT: Asymmetric TSP (generated with 'smatgen %d %d %d')\n",N, seed, maxcoord);
		printf("DIMENSION: %d\n", N);
		printf("EDGE_WEIGHT_TYPE: EXPLICIT\n");
		printf("EDGE_WEIGHT_FORMAT: FULL_MATRIX\n");
		printf("EDGE_WEIGHT_SECTION\n");
	}
	else {
		printf("%d A\n",N);
	}

	for (i=1;i<=N;i++)
	    for (j=1;j<=N;j++) printf("%d\n",a[i*N+j]);

	if (tsplib) {
		printf("EOF\n");
	}
	else {
		printf("smatgen %d %d %d\n",N,seed,maxcoord);
	};
}

