#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "genrand.h"
#define MAXN 3200
#define MAXCOORD 1000000
#define BINSIZE (1 << 30)
#define FACTOR 1

int factor;
int x[MAXN],y[MAXN],z[MAXN],w[MAXN];

int dist(int a, int b);

main(argc,argv)
int argc;
char *argv[];
{
	int maxcoord = MAXCOORD;
	int N;
	int i,j;
	int z1, w1;
	int seed;
	int arg = 1;
	int tsplib = 0;

	if (argc < 4) {
		printf("Usage: cranegen [-tsplib] N seed factor [maxcoord] > filename\n");
		exit(1);
		}
	if (strcmp(argv[arg], "-tsplib") == 0)  {
		tsplib = 1;
		++arg;
	}
	N = atoi(argv[arg++]);
	seed = atoi(argv[arg++]);
	factor = atoi(argv[arg++]);
	if (argc > arg) maxcoord = atoi(argv[arg++]);

	/* initialize random number generator */

	sprand(seed);

	for (i=1;i<=N;i++) {
	    x[i] = rangerand(maxcoord);
	    y[i] = rangerand(maxcoord);
	    z1 = rangerand(maxcoord);
	    z1 = z1/factor;
	    if (lprand() > MAXRAND/2) z1 = -z1;
	    z[i] = z1;
	    w1 = rangerand(maxcoord);
	    w1 = w1/factor;
	    if (lprand() > MAXRAND/2) w1 = -w1;
	    w[i] = w1;
/*
	    printf("%d	%d  %d  %d\n",x[i],y[i],z[i],w[i]);
*/
	    }

	if (tsplib) {
		printf("NAME: cranegen_%d_%d_%d_%d\n", N, seed, factor, maxcoord);
		printf("TYPE: ATSP\n");
		printf("COMMENT: Asymmetric TSP (generated with 'cranegen %d %d %d %d')\n",N, seed, factor, maxcoord);
		printf("DIMENSION: %d\n", N);
		printf("EDGE_WEIGHT_TYPE: EXPLICIT\n");
		printf("EDGE_WEIGHT_FORMAT: FULL_MATRIX\n");
		printf("EDGE_WEIGHT_SECTION\n");
	}
	else {
		printf("%d A\n",N);
	}

	for (i=1;i<=N;i++)
	    for (j=1;j<=N;j++)  printf("%d\n",dist(i,j));

	if (tsplib) {
		printf("EOF\n");
	}
	else {
		printf("cranegen %d %d %d %d\n",N,seed,factor,maxcoord);
	};
}

dist (a,b)
int a,b;
{
    double max, sum, t;
    int rd;

    if (a == b) return (1<<29);
    t = (double) (x[a]+z[a]-x[b]);
    if (t < 0.0) t = -t;
    max = t; sum = t*t;

    t = (double) (y[a]+w[a]-y[b]);
    if (t < 0.0) t = -t;
    if (t > max) max = t;
    sum += t*t;

    if (sum == 0.0) return 0;

    max *= 2.0;
    max =  0.5 * (max + sum/max);
    max =  0.5 * (max + sum/max);
    max =  0.5 * (max + sum/max);
    max =  0.5 * (max + sum/max);
    max =  0.5 * (max + sum/max);
    rd = (int) max;
#ifdef ROUNDUP
    if (max-rd > .00000001) rd++;
#else
    if (max-rd > .5) rd++;
#endif
    return(rd);
}

