/*  Generates coin box collection instances  */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "genrand.h"
#define MAXN 3200
#define MAXBLOCKS 600
#define MAXSTREETS MAXBLOCKS*MAXBLOCKS*4
#define MAXCOORD 1000000
#define FACTOR 1

main(argc,argv)
int argc;
char *argv[];
{
	int maxcoord = MAXCOORD;
	int N;
	int i,j,k,a;
	int s1,x1,y1,a1;
	int x[MAXN], y[MAXN];
	int s[MAXN], d[MAXN], address[MAXN];
	static int dist[MAXSTREETS], marked[MAXSTREETS];
	int blocks2, blocks, infinity, coord, streets;
	int distance;
	int firstp, lastp;
	int seed;
	int arg = 1;
	int tsplib = 0;

	if (argc < 4) {
	   printf("Usage: coingen [-tsplib] N seed blocks [maxcoord] > filename\n");
	   exit(1);
	}

	if (strcmp(argv[arg], "-tsplib") == 0)  {
		tsplib = 1;
		++arg;
	}

	N = atoi(argv[arg++]);
	seed = atoi(argv[arg++]);
	blocks = atoi(argv[arg++]);
	if (argc > arg) maxcoord = atoi(argv[arg++]);

	/* initialize random number generator */

	sprand(seed);

	blocks2 = blocks*blocks;
	infinity = 4*blocks*maxcoord;
	streets = blocks2*4;

	for (i=1;i<=N;i++) {
	    x[i] = rangerand(blocks);
	    y[i] = rangerand(blocks);
	    s[i] = rangerand(4);
	    d[i] = rangerand(maxcoord);
	    address[i] = s[i] + 4*x[i] + 4*blocks*y[i];
	    
	}

	if (tsplib) {
		printf("NAME: coingen_%d_%d_%d_%d\n", N, seed, blocks, maxcoord);
		printf("TYPE: ATSP\n");
		printf("COMMENT: Asymmetric TSP (generated with 'coingen %d %d %d %d')\n",N, seed, blocks, maxcoord);
		printf("DIMENSION: %d\n", N);
		printf("EDGE_WEIGHT_TYPE: EXPLICIT\n");
		printf("EDGE_WEIGHT_FORMAT: FULL_MATRIX\n");
		printf("EDGE_WEIGHT_SECTION\n");
	}
	else {
		printf("%d A\n",N);
	}

	for (i=1;i<=N;i++) {
	   for (k=0;k<streets;k++) {
		dist[k] = infinity;
	   }
	   a = address[i];
	   dist[a] = 0;
	   marked[0] = a;
	   firstp = lastp = 0;
	   while (lastp >= firstp) {

		a = marked[firstp++];
		s1 = a%4;
		a1 = a/4;
		x1 = a1%blocks;
		y1 = a1/blocks;

		if (s1<3) coord = a+1;
		else coord = a-3;
		if (dist[coord] == infinity) {
		   dist[coord] = dist[a]+1;
		   marked[++lastp] = coord;
		}

		if (s1==0)
		   if (x1>0) {
			coord = a-4;
			if (dist[coord] == infinity) {
			    dist[coord] = dist[a]+1;
			    marked[++lastp] = coord;
			}
			if (y1>0) {
			   coord = a-4-4*blocks+3;
			   if (dist[coord] == infinity) {
				dist[coord] = dist[a]+1;
				marked[++lastp] = coord;
			   }
			}
		   }

		if (s1==1)
		   if (y1<blocks-1) {
			coord = a+4*blocks;
			if (dist[coord] == infinity) {
			    dist[coord] = dist[a]+1;
			    marked[++lastp] = coord;
			}
			if (x1>0) {
			   coord = a-4+4*blocks-1;
			   if (dist[coord] == infinity) {
				dist[coord] = dist[a]+1;
				marked[++lastp] = coord;
			   }
			}
		   }

		if (s1==2)
		   if (x1<blocks-1) {
			coord = a+4;
			if (dist[coord] == infinity) {
			    dist[coord] = dist[a]+1;
			    marked[++lastp] = coord;
			}
			if (y1<blocks-1) {
			   coord = a+4+4*blocks-1;
			   if (dist[coord] == infinity) {
				dist[coord] = dist[a]+1;
				marked[++lastp] = coord;
			   }
			}
		   }

		if (s1==3)
		   if (y1>0) {
			coord = a-4*blocks;
			if (dist[coord] == infinity) {
			    dist[coord] = dist[a]+1;
			    marked[++lastp] = coord;
			}
			if (x1<blocks-1) {
			   coord = a+4-4*blocks-1;
			   if (dist[coord] == infinity) {
				dist[coord] = dist[a]+1;
				marked[++lastp] = coord;
			   }
			}
		   }
	   }
	   for (j=1;j<=N;j++) {
		a = address[j];
		distance = maxcoord*dist[a] - d[i] + d[j];
		if (a==address[i]) {
		   if (d[j]>=d[i]) distance = d[j]-d[i];
		   else distance = 4*maxcoord - d[i] + d[j];
		}
		printf("%d\n",distance);
	   }
	}

	if (tsplib) {
		printf("EOF\n");
	}
	else {
		printf("coingen %d %d %d %d\n",N,seed,blocks,maxcoord);
	};
}
