#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "genrand.h"
#define ALPHABET 2
#define FACTOR 1
#define MAXSIZE 3200
#define MAXLENGTH 500
#define xSTRINGPRINT

int length;
int alphabetsize;

char x[MAXSIZE][MAXLENGTH];
char y[MAXLENGTH];
int N, length;

int dist(int i, int j);

main(argc,argv)
int argc;
char *argv[];
{
	int alphabetsize = ALPHABET;
	int N;
	int i,j;
	int seed;
	int c;
	int arg = 1;
	int tsplib = 0;

	if (argc < 4) {
		printf("Usage: supergen [-tsplib] N seed length [alphabetsize] > filename\n");
		exit(1);
		}

	if (strcmp(argv[arg], "-tsplib") == 0)  {
		tsplib = 1;
		++arg;
	}

	N = atoi(argv[arg++]);
	seed = atoi(argv[arg++]);
	length = atoi(argv[arg++]);
	if (argc > arg) alphabetsize = atoi(argv[arg++]);

	/* initialize random number generator */

	sprand(seed);

	for (i=1;i<=N;i++) {
		for (j=0;j<length;j++) {
			c = rangerand(alphabetsize);
			x[i][j] = 'a' + c;
#ifdef STRINGPRINT
			printf("%c",x[i][j]);
#endif
		}
#ifdef STRINGPRINT
		printf("\n");
#endif
	}

	if (tsplib) {
		printf("NAME: supergen_%d_%d_%d_%d\n", N, seed, length, alphabetsize);
		printf("TYPE: ATSP\n");
		printf("COMMENT: Asymmetric TSP (generated with 'supergen %d %d %d %d')\n", N, seed, length, alphabetsize);
		printf("DIMENSION: %d\n", N);
		printf("EDGE_WEIGHT_TYPE: EXPLICIT\n");
		printf("EDGE_WEIGHT_FORMAT: FULL_MATRIX\n");
		printf("EDGE_WEIGHT_SECTION\n");
	}
	else {
		printf("%d A\n",N);
	}

	for (i=1;i<=N;i++) {
		for (j=1;j<=N;j++)
			printf("%d\n",dist(i,j));
	}

	if (tsplib) {
		printf("EOF\n");
	}
	else {
		printf("supergen %d %d %d %d\n",N,seed,length,alphabetsize);
	};
	

	return 0;
}

int dist(int i, int j)
{
int g,h,k;
int dist,d;
int pen;
	dist = length;
	for (h=0;h<length;h++) {
		pen = 0;
		g = 0;
		for (k=h;k<length;k++) {
			if (x[i][k] != x[j][g]) pen+=2;
			g++;
		}
		d = h+pen;
		if (d < dist) dist = d;
	}
	return(dist);
}
