
/* Implementation of the Hungarian algorithm for complete bipartite graphs */
/* Finds the minimum weight complete matching */


#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#define INF 100000000

struct queue {
    int front,back,size;
    int *list;
    };

int augmented;		/* has the matching been augmented yet? */

int scanned,modified;	/* counters */

int last;		/* last node augmented */

int n,*dist;

int *u,*v;		/* dual variables, u on the S side, v on the T side */

int *Smate,*Tmate;	/* holds the current matching */
int *Slabel,*Tlabel;	/* holds the current search paths, -1 = unlabeled */
int *pi;		/* holds the min slack for each vertex in T */

void Check(), Scan_S(), Augment(), Modify(), Init_Dual(), Read_Instance();
void Initqueue(), Clearqueue(), Enqueue();

int Dequeue();

struct queue Q;		/* a queue of unexplored nodes */

int main(argc,argv)
char *argv[];
{
	register int i,node;
	int j,stage,weight,edgelength,done;

        if (argc < 2) {
                printf("Usage: match filename\n");
                exit(0);
                }

	Read_Instance(argv[1]);

	Init_Dual();

	Initqueue(&Q,2*n);

	scanned = modified = 0;
	last = 1;

	for (stage=1; stage<=n; stage++) {
#ifdef DEBUG
		Check();
#endif
		Clearqueue(&Q);
		augmented = 0;

#ifdef DEBUG
		printf("\n Stage %d\n",stage);
#endif
		for (i=1; i<=n; i++)
			Slabel[i] = -1;

		done = 1;
		for (i=last; i<=n; i++)    /* enqueue all exposed S nodes */
			if (Smate[i] == 0) {
				Slabel[i] = 0;
				Enqueue(&Q,i);
				done = 0;
				}
		for (i=1; i<last; i++)
			if (Smate[i] == 0) {
				Slabel[i] = 0;
				Enqueue(&Q,i);
				done = 0;
				}

		if (done) break;	/* if none are exposed, we're done */

		for (j=1; j<=n; j++) {
			Tlabel[j] = -1;
			pi[j] = INF;
			}

		while (!augmented) {
			node = Dequeue(&Q);
			if (node == -1) Modify();	/* Empty queue */
			else if (node <= n) Scan_S(node);
			else {
				node -= n;	/* its on the T side */
				if (Tmate[node] == 0) {
 					Augment(node);
					}
				else {
#ifdef DEBUG
					printf("Scan_T %d\n",node);
#endif
					Slabel[Tmate[node]] = node;
					Enqueue(&Q,Tmate[node]);
					}
				}

			}

		}

	for (i=1; i<=n; i++) if (Smate[i] == 0) printf("Node %d not matched\n",i);
#ifdef DEBUG
	Check();
#endif
	weight = 0;
	for (i=1; i<=n; i++) {
		edgelength = dist[i*n+Smate[i]];
		weight += edgelength;
		/* printf("%4d -- %4d  :  %6d\n",i,Smate[i],-edgelength); */
	}
		
/*	printf("%d nodes scanned, %d dual modifies\n",scanned,modified);*/
	printf("Final cost = %d\n",-weight);
}


void Check()
{	int i,j;

	for (i=1; i<=n; i++) if (Smate[i] != 0)
		if (Tmate[Smate[i]] != i) printf("Bogus S %d match\n",i);
	for (j=1; j<=n; j++) if (Tmate[j] != 0)
		if (Smate[Tmate[j]] != j) printf("Bogus T %d match\n",j);
	for (i=1; i<=n; i++)
		for (j=1; j<=n; j++)
			if (Smate[i] == j && u[i] + v[j] != dist[i*n+j])
				printf("Bogus equal %d %d\n",i,j);
			else if (u[i]+v[j] < dist[i*n+j])
				printf("Bogus less than %d %d\n",i,j);

		printf("u,v:\n");
		for (i=1; i<n; i++) printf("%d ",u[i]);
		printf("%d\n",u[n]);
		for (j=1; j<n; j++) printf("%d ",v[j]);
		printf("%d\n",v[n]);
		for (j=1; j<n; j++) printf("%d ",pi[j]);
		printf("%d\n",pi[n]);
}

void Scan_S(i)
int i;
{	register int in,j,slack;
	int matei;
#ifdef DEBUG
	printf("Scan_S %d\n",i);
#endif
	scanned++;
	in = i*n;
	matei = Smate[i];
	for (j=1; j<=n; j++) if (j != matei) {	/* for each T node */
		slack = u[i]+v[j]-dist[in+j];
		if (slack < pi[j]) {
			pi[j] = slack;
			Tlabel[j] = i;
			if (pi[j] == 0) {
				if (Tmate[j] == 0) {
					Augment(j);
					last = i;
					break;
					}
				else Enqueue(&Q,j+n);
				}
			}
		}
}

void Augment(j)
{	register int i;

	augmented = 1;

	while (j!=0) {		/* trace the augmenting path */
		i = Tlabel[j];
#ifdef DEBUG
		printf("Match %d to %d\n",i,j);
#endif
		Smate[i] = j;
		Tmate[j] = i;
		j = Slabel[i];
		}
}

void Modify()
{
	register int i,j,delta;

#ifdef DEBUG
	printf("Modify dual variables\n");
#endif
	modified++;
	delta = INF;
	for (j=1; j<=n; j++)	/* find the smallest non-zero slack */
		if (pi[j] > 0 && delta > pi[j]) delta = pi[j];

	for (i=1; i<=n; i++)	/* subtract it from each labeled S node */
		if (Slabel[i] >= 0) u[i] -= delta;

	for (j=1; j<=n; j++)	/* add it to each scanned T node */
		if (pi[j] == 0) v[j] += delta;
		else if (Tlabel[j] >= 0) {
			pi[j] -= delta;
			if (pi[j] == 0) Enqueue(&Q,j+n);
			}
#ifdef DEBUG
		printf("After modify u,v:\n");
		for (i=1; i<n; i++) printf("%d ",u[i]);
		printf("%d\n",u[n]);
		for (j=1; j<n; j++) printf("%d ",v[j]);
		printf("%d\n",v[n]);
		for (j=1; j<n; j++) printf("%d ",pi[j]);
		printf("%d\n",pi[n]);
#endif
}

void Init_Dual()
{	register int val,in,i,tmp,close;
	int j;
	int matecount = 0;

	for (i=1; i<=n; i++) Smate[i] = 0;
	for (j=1; j<=n; j++) {
		Tmate[j] = 0;
		pi[j] = INF;
		}
	for (i=1; i<=n; i++) {
		tmp = -INF;
		in = i*n;
		for (j=1; j<=n; j++) {
			val = dist[in+j];
			if (tmp < val)
				tmp = val;
			}
		u[i] = tmp;
		}
	for (j=1; j<=n; j++) {
		tmp = -INF;
		for (i=1; i<=n; i++) {
			val = dist[i*n+j]-u[i];
			if (tmp < val) {
				close = i;
				tmp = val;
				}
			}
		v[j] = tmp;
		if (Smate[close] == 0) {   /* start with a greedy match */
			Smate[close] = j;
			Tmate[j] = close;
			matecount++;
			}
		}
/*	printf("%4d edges in greedy matching\n",matecount); */
}

void Read_Instance(file)
char *file;
{	register int i,j;
	FILE *fopen(), *fd;
	char c;
	int k;


	fd = fopen(file,"r");
	if (fd == NULL) {
        	printf("Error opening input file\n");
        	exit(0);
	}

	fscanf(fd,"%d %c",&n,&c);
	if (c!='A') {
		printf("ReadR: file %s is not in correct format\n",file);
		exit(0);
	}

	if ((u = (int *) malloc((n+1)*sizeof(int))) == NULL) {
		printf("malloc of u failed\n");
		exit(1);
	}
	if ((v = (int *) malloc((n+1)*sizeof(int))) == NULL) {
		printf("malloc of u failed\n");
		exit(1);
	}
	if ((dist = (int *) malloc((n*(n+1)+1)*sizeof(int))) == NULL) {
		printf("malloc of dist failed\n");
		exit(1);
	}
	if ((Smate = (int *) malloc((n+1)*sizeof(int))) == NULL) {
		printf("malloc of Smate failed\n");
		exit(1);
	}
	if ((Tmate = (int *) malloc((n+1)*sizeof(int))) == NULL) {
		printf("malloc of Tmate failed\n");
		exit(1);
	}
	if ((Slabel = (int *) malloc((n+1)*sizeof(int))) == NULL) {
		printf("malloc of Slabel failed\n");
		exit(1);
	}
	if ((Tlabel = (int *) malloc((n+1)*sizeof(int))) == NULL) {
		printf("malloc of Tlabel failed\n");
		exit(1);
	}
	if ((pi = (int *) malloc((n+1)*sizeof(int))) == NULL) {
		printf("malloc of pi failed\n");
		exit(1);
	}

	for (i=1; i<=n; i++) {
		for (j=1; j<=n; j++) {
			fscanf(fd,"%d",&k);
			dist[i*n+j] = -k;
			}
		dist[i*n+i] = -INF;
		}
#ifdef DEBUG
	for (i=1; i<=n; i++) {
		for (j=1; j<=n; j++)
			printf("%d ",dist[i*n+j]);
		printf("\n");
		}
#endif
}

/* Operations on queue data type */

void Initqueue(Q,size)
struct queue *Q;
{
    Q->size  = size;
    Q->front = 0;
    Q->back  = size;
    if ((Q->list = (int *) malloc((size+1)*sizeof(int))) == NULL) {
		printf("malloc of Q->list failed\n");
		exit(1);
	}
}

void Clearqueue(Q)
struct queue *Q;
{
    Q->front = 0;
    Q->back = Q->size;
}

void Enqueue(Q,node)
struct queue *Q;
int node;
{
    if (Q->front==Q->back) { printf("Error: queue full\n"); exit(0); }
    Q->list[Q->front++] = node;
    if (Q->front > Q->size) Q->front = 0;
}


int Dequeue(Q)
struct queue *Q;
{   int oldback;

    oldback = Q->back++;
    if (Q->back > Q->size) Q->back = 0;
    if (Q->back == Q->front) {
	Q->back = oldback;
	return(-1);
	}
    return(Q->list[Q->back]);
}
