#include "genrand.h"

static int RAND[55];
static int K;
static int J;

static int sprand_compat (int seed);

/* rangerand returns an integer (roughly) uniform from 0 to range-1.
   It uses a slightly strange rounding to be compatible (on an sgi) with
   an earlier, machine dependent version, while being machine independent */


int rangerand (int range)
{
  int x = lprand();
  int xs = x % HMAXRAND;
  int xl = x / HMAXRAND;
  int rs = range % HMAXRAND;
  int rl = range / HMAXRAND;
  int v = xl*rl + (xs*rl + xl*rs + xs*rs / HMAXRAND)  / (MAXRAND / HMAXRAND);
  
  return v;
}

/* lprand returns an integer uniform from 0 to MAXRAND-1 */

int lprand (void)
{
  int t;
  
  if (K == 0) K = 54;
  else K -= 1;
  if (J == 0) J = 54;
  else J -= 1;

  t = RAND[K] + RAND[J];
  if (t >= MAXRAND) t -= MAXRAND;
  RAND[K] = t;
  return t;
}

void sprand (int seed)
{
                 /* We will use an algorithm of Knuth's to
                    generate random numbers.  It is
                    based on an array of 55 values.
                    randinit is called to initialize
                    this array by calling the system
                    random number generator.  All
                    uses of random numbers are done
                    by reference to lprand. */
    int i;

    if (!sprand_compat (seed)) {
      int last, next;
      int ii;
      
      RAND[0] = last = seed;
      next = 1;
      for (i=1; i<55; i++) {
        ii = (21*i)%55;
        RAND[ii] = next;
        next = last - next;
        if (next < 0) next += MAXRAND;
        last = RAND[ii];
      }
    }

    J = 23;
    K = 54;

    for (i=0;i<165;i++) lprand();
}

static int sprand_compat (int seed)
/* An old version used srand/rand, which are not machine independent, to
   initialize the table.  To maintain compatibility with some published
   instances, we load them via a table */
{
  int tbl;
  int i;
  static int rand_compat[24][55] = {
        { 703463424, 724739844, 554667434, 646889133, 275591002, 886452197,
          319755803, 847893087, 859635312, 578730860, 268423184, 769120793,
          353303904, 760625412, 185523892, 840270338, 641467718, 597499763,
          426754546, 693573471, 327441335, 896072793, 756855278, 652578832,
          751486536, 426144693, 664070793, 402620945, 601558534, 160903010,
           77489887, 211454713, 589689597, 403979924, 486837450, 404891516,
         1015091123, 466314590,  22661215, 171375338, 803876012, 893443117,
          750032750,1064306351, 172196838, 726564684, 259228932, 169562578,
          471233629, 535096928, 838472938, 855310457, 139470214, 482974699,
          796008230},
        { 188694982, 573941633, 184416587, 243128802, 133906260, 418351805,
          395191164, 574881249, 694149633, 837771825, 163146070, 337891343,
          984820839, 430752391, 843337130, 934082364, 724266730, 624812307,
          381858258, 887888289, 497694012, 135789909,1029118775, 439213669,
          813786074,  30177913, 812755148, 633020186,1026524558,  63744217,
          982497423, 127617343, 270649582, 254197624, 436026637, 458452926,
          410136026, 172426630, 747946716, 430378093, 262890239, 246950881,
          327001632,  39383439, 428004184, 786618000, 250509321,1038543699,
          463332266, 869062216, 300520530, 927895890, 223338502, 316314090,
          235103938},
        { 747668364, 423176191, 887874797, 913110296,1065996110,1024058773,
          470659292, 301869411, 528696723,  23038198,  57836188, 980436486,
          542661485, 100846602, 427375775,1027861621, 807032974, 652092083,
          336961971,   8461282, 667979456, 449216081, 227640448, 225848505,
          876052845, 707920189, 961439502, 863386659, 377748759,1040294480,
          813730367,  43714437,1025318623, 104382556, 385248591, 512014336,
          878955520, 952280495, 399523161, 689446385, 795613523, 674233237,
          977712339,  88169584, 683778762, 846638549, 241756943, 833750227,
          455463671, 129252913, 836342714,1000481323, 307174021, 149620713,
          747908702},
        { 232899923, 272377981, 517623950, 509317197, 924311368, 555958381,
          546094653,  28857573, 363211044, 282079163,1026300899, 549207036,
          100469364, 844682636,  11414421,  47899055, 889799218, 679437395,
          292065683, 202776099, 838264901, 762642252, 499969481,  12516109,
          938352383, 311953409,  36349265,  20044076, 802714784, 943102919,
          645028846,1033586124, 706311376,1028342080, 334405009, 565542979,
          274033190, 658392536,  51066838, 948481909, 254627750,  27741002,
          554681222, 136955729, 939586108, 906691866, 233004564, 628989524,
          447595076, 463218202, 298390305,1073066755, 391042308,1056734696,
          187004410},
        { 791873305, 121612539, 147340335, 105556866, 782626626,  87857989,
          621530013, 829587559, 197758133, 541120128, 920991017, 117977587,
          732019066, 514776847, 669227658, 141678312, 972565462, 706717171,
          247136627, 397090916,1008517578,   2293832, 772232979, 872892769,
         1000684690, 989728453, 185066388, 250443317, 153938984, 845911358,
          476294558, 949715986, 387271361, 878527012, 283626963, 619104389,
          742787149, 364504577, 776385107, 133775608, 787351033, 454990590,
          131650104, 185774642, 121618862, 966745183, 224252185, 424228820,
          439693714, 797183491, 834179721,  71910364, 474877828, 890074087,
          699809175},
        { 277137631,1044556152, 850798545, 775538360, 640974652, 693532189,
          696965373, 556575721,  32305222, 800161092, 815713903, 760522730,
          289859712, 184871058, 253266303, 235457570,1055331706, 734029716,
          202273107, 591405734, 105061198, 315720004,1044496476, 659494838,
         1062984229, 593761673, 333717975, 480777023, 578872241, 748719798,
          307560270, 865845848,  68198578, 728744712, 232816150, 672665799,
          137864819,  70616618, 427928784, 392811132, 246332492, 882272946,
          782393579, 234560787, 377393440,1026765732, 215467038, 219468117,
          431825119,  57439724, 296260081, 144495797, 558746115, 723380710,
          138872115},
        { 836078246, 893790710, 480547698, 371778029, 499257143, 225431797,
          772433502, 283596651, 940594136,1059169289, 710436790, 329293280,
          921376647, 928707093, 911112309, 329236827,  64388894, 761342260,
          157376819, 785720551, 275346643, 629146176, 243018149, 446162442,
           51541943, 197794893, 482402330, 711176264,1003838265, 651528237,
          138825981, 781975711, 822933155, 578929644, 182005336, 726227210,
          606651546, 850470483,  79505229, 651846656, 779088543, 235813479,
          359362461, 283346932, 633200786,  13077225, 206714660,  14707413,
          423923756, 391405013, 832049496, 217081230, 642581635, 556720102,
          651709647},
        { 321342572, 742992500, 110296851,1041726754, 357605169, 831105997,
          847868862,  10552045, 775108457, 244468430, 605126908, 971838423,
          479217293, 598801303, 495150954, 423048853, 147155138, 788654804,
          112480531, 980035368, 445599319, 942572348, 515314414, 232797278,
          113808714, 875537169, 631086685, 941575505, 355062466, 554369444,
         1043800749, 698105573, 503893140, 429147344, 131194522, 779788620,
            1729216, 556582524, 804790730, 910882180, 238070003, 663063067,
         1010073168, 332165845, 888975364,  73130542, 197962281, 883655765,
          416087929, 725370302, 294129856, 289666662, 726449922, 390059493,
           90772588},
        { 880283186, 592227058, 813755060, 637933655, 215920427, 363005605,
          923271455, 811314799, 609655546, 503509395, 499817026, 540608973,
           37025172, 268862746,  79222367, 516828110, 229921382, 815934580,
           67551476, 100608361, 615884764, 182256695, 787610679,  19399347,
          176108253, 479570389, 779771039,  98200154, 779995723, 457210651,
          875099229, 614235435, 184820357, 279332276,  80383709, 833350031,
          470483174, 262727332, 456367176,  96175879, 770826054,  16603599,
          587009282, 380951990,  71040886, 133183858, 189209902, 678895062,
          408219335,1059302823, 829919272, 362252095, 810318210, 223398884,
          603610120},
        { 365547512, 441428847, 443504214, 234173325,  74235685, 968679805,
          998706815, 538302961, 444202635, 762484824, 394539913, 109412292,
          668574874,1012698781, 737002837, 610607368, 312687626, 843279893,
           22655188, 294923179, 786137441, 495682867,1059874176, 879808775,
          238407791,  83603609, 928422626, 328566627, 131219923, 360019090,
          706364941, 530365298, 939554934, 129549976,  29572895, 886878673,
          939302669,1042548429, 107910853, 355211403, 229807513, 443853188,
          163978165, 429770903, 326815464, 193204407, 180457524, 474134358,
          400317972, 319526288, 291999631, 434837528, 894153729,  56705507,
           42673060},
        { 924520895, 290663405,  73220599, 904154818,1006325535, 500579413,
             433120, 265291123, 278749725,1021525789, 289262799, 751957435,
          226415521, 682825760, 321074250, 704386625, 395453870, 870559669,
         1051500724, 489237996, 956422885, 809141807, 258395849, 666443611,
          300707330, 761378653,   3397925, 558965868, 556185948, 262827529,
          537597884, 446495160, 620514919,1053476732,1052536673, 940472851,
          334380339, 748660470, 833229122, 614246927, 762563564, 871135544,
          814688872, 478557048, 582590042, 253290492, 171705145, 269373655,
          392449377, 653524345, 827789047, 507422961, 978022016, 963786722,
          555510592},
        { 409752453, 139865195, 776678808, 500394487, 864640793,  32479021,
           75868480,1066053877, 113264046, 206824929, 183985685, 320727985,
          857932455, 352919970, 978854720, 798165883, 478220114, 897904981,
         1006604436, 683552813,  52966506,  48826155, 530659347, 453111215,
          362974100, 365411873, 152049512, 789332341, 981119204, 165635969,
          368896364, 362625022, 301442136, 903661664,1001693092, 994001494,
          803167065, 454772511, 484772799, 873282451, 221512256, 224643308,
          391657754, 527343193, 838397388, 313311041, 162985534,  64612951,
          384548014, 987489634, 289836639, 580008394,1061890304, 797126113,
         1068315357},
        { 968725835,1062841577, 406427961,  96601389, 722956051, 638185989,
          151303841, 793042039,1021552959, 465833126,  78708571, 963273128,
          415773101,  23014181, 562926133, 891945140, 561019126, 925184757,
          961708148, 877867630, 223219182, 362252327, 802955612, 239713284,
          425273639,1043186917, 300766635,1019731583, 332343405,  68444408,
          200129308, 278754885,1056176713, 753879364, 950915046,1047562904,
          198244736, 160917320, 136349244,  58576150, 754268307, 651892897,
         1042401229, 576129338,  20430142, 373364358, 154233155, 933561304,
          376679420, 247713099, 825658822, 652593826,  72016767, 630432737,
          507411065},
        { 453957394, 912043366,  36144347, 766582882, 581304077, 170085597,
          226739201, 520030201, 856067281, 724874091,1047107746, 532043679,
         1047322804, 766850216, 146964778, 985757166, 643785370, 952497302,
          916811860,1072182447, 393504627, 675678498,   1477285,  26348120,
          487573178, 647220137, 449418222, 176389000, 757309430,1045027439,
           31395019, 194884747, 737136698, 604064295, 900071464,  27382490,
          666998694, 940738417, 861634745, 317611674, 213282534,   5433429,
          619370111, 624948251, 276204720, 433417675, 145480777, 728800600,
          368778057, 581678388, 287706414, 725179259, 155852287, 463772128,
         1020215829},
        {1012930776, 761277924, 739635324, 362822551, 439586567, 775727029,
          302207329, 247018364, 690647138, 983915056, 941830632, 100814229,
          605130682, 436944427, 804810784,   5794599, 726551614, 979809846,
          871915573, 192755441, 563790072, 989104670, 273773550, 886757548,
          549872716, 251253357, 598102576, 406722705, 108500862, 947835878,
          936435323, 111014609, 418063915, 454281995, 849293418,  80943901,
           62076365, 646850458, 513243958, 576679966, 746005817, 432683017,
          196338994, 673767163, 532012066, 493470992, 136728398, 524039896,
          360909462, 915610909, 823528598, 797764692, 239720574, 297111519,
          459278770},
        { 498195102, 610479714, 369384477,1032771277, 297934593, 307626637,
          377642690,1047781118, 525161459, 169181429, 836553518, 743359372,
          162938561, 107038637, 388849429,  99573857, 809317858,1007122390,
          827019285, 387070258, 734042748, 228789018, 546037047, 673359616,
          612139487, 928995633, 746786931, 637121946, 533466887, 850644317,
          767668267,  27111704,  99056668, 304466927, 798482605, 134505311,
          530863091, 352995266, 164787635, 835682722, 205020044, 859965374,
          847049701, 722553308, 787786644, 553491540, 127976019, 319279193,
          353073635, 175834374, 285576190, 870350125, 323556094, 130450910,
          972116302},
        {1057135717, 459714271,1072842687, 629010946, 156249851, 913300837,
          453078050, 774736512, 359708548, 428222394, 731276405, 312129922,
          794521031, 850874672,1046629899, 193353114, 892084102,1034402166,
          782122997, 581385075, 904328193, 542215190, 818333312, 460027221,
          674439026, 533028852, 895471286, 867521187, 958432911, 753452756,
          598933979,1017016158, 853758477, 154684627, 747639023, 188033954,
          999682585,  59107307, 890105904,  20976421, 737743328, 213505906,
          423985815, 771339453,1043593990, 613577625, 119223641, 114518489,
          345172273, 509832431, 821365605, 942902789, 407424381,1037532125,
          411179242},
        { 542400043, 308916061, 702559072, 225217847,  14565109, 445200445,
          528513411, 501757442, 194255638, 687263358, 625999291, 954675065,
          352328910, 520968883, 630701312, 287132372, 974850346,1061747478,
          737193941, 775699892,    871813, 855641362,  16854986, 246662057,
          736738564, 137062072,1044122873,  24145836, 309657112, 656261196,
          430199690, 933113252, 534685694,   4869559, 696860977, 241628132,
          394694720, 838928404, 541649581, 280011945, 196724787, 640755494,
             954698, 820125598, 225626744, 673598174, 110471262, 983466842,
          337303678, 843797720, 283445965,1015488222, 491259900, 870871516,
          924016774},
        {  27598833, 158150619, 332308225, 895199341, 946654959,1050874645,
          603948771, 228745604,  28802727, 946304323, 520656641, 523445616,
          983878612, 191095862, 214739957, 380911629,1057649358,  15285431,
          692297653, 970014710, 171124490,  95325709, 289118483,  33296893,
          799038103, 814837116, 119098172, 254512309, 734623136, 559069635,
          261465402, 849275883, 215678447, 928829083, 646050164, 295156774,
          863514214, 545040445, 193226026, 539047469, 729480838,1068037851,
          651698172, 868911743, 481401322, 733651491, 101718883, 778706138,
          329402315, 104021185, 819235381,  14331831, 575128188, 704210908,
          363079715},
        { 586604984,   7352409,1035766434, 491439010, 804970217, 582807021,
          679384132,1029475590, 937091640, 131537928, 415379528,  92248934,
          541719258, 934931896, 872553195, 474723655,  66673778,  42597975,
          647401365,  90587703, 341377167, 408784649, 561381980, 893673554,
          861337641, 418870336, 267749758, 484911551,  85847337, 461910842,
           92731114, 765372977, 970380256, 779014015, 595239350, 348718185,
          258591885, 251185254, 918511528, 798082992, 188462297, 421545615,
          228667055, 917763424, 737208668, 793704808,  92966504, 573945435,
          321533720, 437986474, 281315740,  86917264, 658996475, 537517531,
          875917247},
        {  71836542, 930328790, 665515588,  87678679, 663285475, 114706629,
          754819492, 756463752, 771605961, 390578893, 310102414, 734761309,
           99494369, 605026107, 456591840, 568502912, 149440022,  69910519,
          602537846, 284935288, 511695379, 722210821, 833711013, 680308390,
          923604412,  22903556, 416434113, 715310792, 510780594, 364719281,
          997738649, 681502839, 651307473, 629231715, 544428536, 402279595,
          727378611,1031039119, 570055205,1057151284, 721218349, 848795203,
          879377762, 966549569, 992983246, 853725357,  84214126, 369184731,
          313632358, 771918995, 817105156, 159502696, 742831995, 370856922,
          314980187},
        { 630809924, 779530580, 295264741, 757660173, 521633501, 720348061,
          830254853, 483484682, 606153051, 649619858, 204825300, 303531859,
          731076839, 275087550,  40696022, 662282170, 232206266,  97190295,
          557641558, 479250105, 681948056,1035636993,  32232686, 466975994,
          985936719, 700645832, 565118468, 945677265, 935746618, 267527720,
          829004361, 597632702, 332300226, 479416647, 493617723, 455808237,
          122423513, 737118392, 221631650, 242444984, 180199808, 202335735,
          456346644,1015335714, 175016000, 913778673,  75494515, 164424028,
          305763763,  32175228, 279152748, 232088129, 826700282, 204196313,
          827817720},
        { 116041482, 628765138, 998722950, 353834306, 379915991, 252280437,
          905722981, 210440076, 440667372, 908628054,  99515419, 946109770,
          288851950,1018923585, 698476491, 756061427, 314972511, 124502840,
          512712502, 673564922, 852200732, 275321341, 304496183, 253578062,
         1048236257, 304679052, 713802823, 102301914, 286970819, 170336159,
          660270073, 513762564,  13260211, 329634347, 442806909, 509402416,
          591210240, 443263200, 946917151, 501480508, 712955859, 629585324,
           33315527,1064121859, 430823346, 973831990,  66742136,1033372380,
          297895168, 366140517, 814974931, 304673562, 910535802,  37535704,
          266880660},
        { 292894013, 496252352, 184068753, 344911597, 320245416, 802575669,
          435464041, 173894556, 190720374, 833373821, 330942029, 717597951,
         1046347809, 527193686, 592174966, 432586431, 977200767, 342970425,
          153542199,  80599812,  66935105, 635279835, 335218816, 694173169,
          472825206, 358137516, 829503070, 871622947, 465375240, 466611033,
          384137591, 916510519, 682132795, 204953931,  36353167, 937828163,
           46635059, 239643175, 306881288, 426248282, 679840365, 826487630,
          944066651, 380767498, 329634626, 380451165,1070497699, 468995807,
          234880874, 890379181, 806421265, 885357024, 507609205, 851668946,
           74417014},
  };
  
  if (seed >= 0 && seed <= 22) {
    tbl = seed;
  } else if (seed == 30) {
    tbl = 23;
  } else {
    return 0;
  }
  for (i=0; i<55; i++) {
    RAND[i] = rand_compat[tbl][i];
  }
  return 1;
}
